# 機能設計書 54-Apache プロバイダー

## 概要

本ドキュメントは、Horse WebフレームワークにおけるApacheモジュールプロバイダー機能の設計を記述する。

### 本機能の処理概要

Apache プロバイダーは、Apache HTTP Server のモジュールとしてHorseアプリケーションを動作させるための機能を提供する。Apache 2.4 互換のモジュールとしてコンパイルされ、Apacheプロセス内でインプロセスで実行される。DelphiおよびFree Pascal/Lazarus両方の環境で動作可能。

**業務上の目的・背景**：Apacheは世界で最も広く使用されているWebサーバーの一つであり、多くの既存インフラで運用されている。Apache プロバイダーにより、Apacheの豊富な機能（mod_ssl、mod_rewrite、認証モジュール等）を活用しながら、Horseアプリケーションをネイティブに統合できる。クロスプラットフォーム対応により、WindowsとLinux/Unix環境の両方で運用可能。

**機能の利用シーン**：
- Apache HTTP Serverを使用する既存インフラへのWebアプリケーション統合
- クロスプラットフォーム（Windows/Linux）でのWebアプリケーション運用
- Apacheの認証・リライト・プロキシ機能を活用したい場合
- 共有ライブラリ（.so/.dll）としてのモジュールデプロイ

**主要な処理内容**：
1. Apacheモジュールとしての初期化（InitApplication）
2. HandlerName と ModuleName の設定
3. モジュールレコードの設定（SetModuleRecord）
4. WebModuleClass の設定による THorseWebModule の登録
5. MaxConnections の設定（オプション）
6. 起動時コールバックの実行
7. Application.Run / Initialize によるリクエスト処理

**関連システム・外部連携**：
- Apache HTTP Server 2.4
- Windows COM基盤（Windowsの場合、COINIT_MULTITHREADED）
- Delphi WebBroker フレームワーク（Web.ApacheApp）/ FPC fpApache24

**権限による制御**：Apache プロバイダー自体には権限制御機能はなく、Apacheの認証・認可設定に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Webモジュール | API連携 | ApacheモジュールとしてHTTPリクエストを処理 |

## 機能種別

サーバー管理 / Apache モジュール実行基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| HandlerName | string | Yes | Apacheハンドラ名 | - |
| ModuleName | string | Yes（FPC版） | モジュール名 | - |
| DefaultModule | Pointer/pmodule | Yes | モジュールレコードへのポインタ | - |
| MaxConnections | Integer | No | 最大同時接続数 | 0より大きい場合に設定 |
| Callback | TProc | No | 起動時コールバック | - |

### 入力データソース

- Apacheからのモジュールリクエスト
- Apache設定ファイル（httpd.conf等）による環境パラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Apacheレスポンス | - | Apacheを介したHTTPレスポンス |

### 出力先

- Apacheへのモジュールレスポンス送信

## 処理フロー

### 処理シーケンス

```
1. Apache モジュール読み込み
   └─ Apacheによるモジュール初期化
2. Listen メソッド呼び出し
   └─ InternalListen を呼び出す
3. COM初期化フラグ設定（Windowsのみ）
   └─ CoInitFlags := COINIT_MULTITHREADED
4. Apacheアプリケーション初期化
   └─ [Delphi] InitApplication(FDefaultModule, UTF8String(FHandlerName))
   └─ [FPC] ModuleName/HandlerName/SetModuleRecord設定
5. Application.Initialize 呼び出し
6. WebModuleClass 設定
   └─ THorseWebModule を Application.WebModuleClass に設定
   └─ [FPC] OnGetModule イベントハンドラ設定
7. MaxConnections 設定（指定時）
8. コールバック実行
   └─ DoOnListen で起動時コールバック実行
9. アプリケーション実行
   └─ Application.Run [Delphi] / Application.Initialize [FPC]
```

### フローチャート

```mermaid
flowchart TD
    A[Apache モジュール読み込み] --> B[Listen 呼び出し]
    B --> C{Windowsか?}
    C -->|Yes| D[CoInitFlags = COINIT_MULTITHREADED]
    C -->|No| E{Delphi or FPC?}
    D --> E
    E -->|Delphi| F[InitApplication]
    E -->|FPC| G[ModuleName/HandlerName設定]
    F --> H[Application.Initialize]
    G --> I[SetModuleRecord]
    I --> J[OnGetModule設定]
    J --> K[AllowDefaultModule = True]
    K --> L[LegacyRouting = True]
    H --> M[WebModuleClass = THorseWebModule]
    L --> N[DoOnListen]
    M --> O{MaxConnections > 0?}
    O -->|Yes| P[MaxConnections設定]
    O -->|No| Q[DoOnListen]
    P --> Q
    Q --> R[Application.Run]
    N --> S[Application.Initialize]
    R --> T[終了]
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | モジュールインプロセス実行 | Apacheプロセス内でモジュールとして実行 | Apache モード動作時 |
| BR-54-02 | Apache 2.4 互換 | Apache 2.4 APIに準拠したモジュールとして動作 | モジュールビルド時 |
| BR-54-03 | ハンドラ名必須 | HandlerNameを設定する必要がある | Apache モード動作時 |
| BR-54-04 | FPC版ではモジュール名必須 | ModuleNameを設定する必要がある | FPC版使用時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EHorseCallbackInterrupted | コールバックチェーン中断時 | 例外を捕捉して正常終了として扱う |

### リトライ仕様

Apacheモジュールモデルではリトライ機能は実装されていない。Apacheのリトライ設定に依存する。

## トランザクション仕様

Apacheモジュールとして動作するため、データベーストランザクションは本機能では管理しない。

## パフォーマンス要件

- インプロセス実行によりプロセス起動オーバーヘッドなし
- Apacheのマルチプロセス/マルチスレッドモデルを活用
- MaxConnections でリソース制限が可能

## セキュリティ考慮事項

- Apacheの認証・認可設定に依存
- モジュールとして実行されるため、適切なファイル権限設定が必要
- Unix環境ではスレッドサポート（cthreads）が必要

## 備考

- HORSE_APACHE コンパイルディレクティブが定義されている必要がある
- 共有ライブラリ（.so/.dll）としてコンパイルする必要がある
- Delphi版とFPC/Lazarus版で実装が異なる
- StopListen機能は提供されない（Apacheモジュールモデルの特性上、Apacheが制御）
- FPC版ではcthreadsユニットが必要（Unix環境）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Apache プロバイダーの設定に使用されるプロパティを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstract クラスの定義 |

**読解のコツ**: Apache プロバイダーはHandlerName、ModuleName、DefaultModuleの設定が必須。これらはApacheの設定ファイルと対応する。

#### Step 2: Delphi版Apacheプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Apache.pas | `src/Horse.Provider.Apache.pas` | THorseProvider クラスの実装（Delphi版） |

**主要処理フロー**:
- **5行目**: `{$IF DEFINED(HORSE_APACHE) AND NOT DEFINED(FPC)}` - Delphi専用条件コンパイル
- **9行目**: Web.HTTPD24Impl ユニットを使用
- **14-16行目**: クラス変数定義（FMaxConnections, FHandlerName, FDefaultModule）
- **40-43行目**: プロパティ宣言（MSWINDOWS条件コンパイルあり）
- **46-50行目**: InternalListen（Windows版）
  - 49行目: CoInitFlags := COINIT_MULTITHREADED
- **51-62行目**: InternalListen 本体
  - 51行目: InitApplication - Apacheアプリケーション初期化
  - 52行目: Application.Initialize
  - 53行目: WebModuleClass設定
  - 55-58行目: MaxConnections設定（条件付き）
  - 60行目: DoOnListen
  - 61行目: Application.Run

#### Step 3: FPC/Lazarus版Apacheプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.FPC.Apache.pas | `src/Horse.Provider.FPC.Apache.pas` | THorseProvider クラスの実装（FPC版） |

**主要処理フロー**:
- **9行目**: `{$IF DEFINED(HORSE_APACHE) AND DEFINED(FPC)}` - FPC専用条件コンパイル
- **11-13行目**: cthreadsユニットのインクルード（Unix環境用）
- **17-18行目**: httpd24, fpApache24, custapache24 ユニットを使用
- **28-30行目**: クラス変数定義（FHandlerName, FModuleName, FDefaultModule）
- **88-102行目**: InternalListen
  - 93-94行目: ModuleName/HandlerName設定
  - 96行目: SetModuleRecord - モジュールレコード設定
  - 97行目: AllowDefaultModule := True
  - 98行目: OnGetModule := DoGetModule
  - 99行目: LegacyRouting := True
  - 100行目: DoOnListen
  - 101行目: Initialize
- **104-107行目**: DoGetModule - THorseWebModule を返却

#### Step 4: WebModuleを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | THorseWebModule クラス、リクエスト処理 |

**主要処理フロー**:
- **87-110行目**: HandlerAction - リクエスト・レスポンス処理

#### Step 5: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Apache.pas | `samples/lazarus/apache/Apache.pas` | Lazarus版Apacheモジュール使用例 |

### プログラム呼び出し階層図

```
Apache HTTP Server
    │
    └─ モジュール読み込み
           │
           └─ THorse (Horse.pas)
                  │
                  └─ THorseProvider (Horse.Provider.Apache.pas / Horse.Provider.FPC.Apache.pas)
                         │
                         └─ Listen()
                                └─ InternalListen()
                                       │
                                       ├─ [Delphi版]
                                       │      ├─ CoInitFlags := COINIT_MULTITHREADED [Windows]
                                       │      ├─ InitApplication(FDefaultModule, FHandlerName)
                                       │      ├─ Application.Initialize()
                                       │      ├─ WebModuleClass := THorseWebModule
                                       │      ├─ MaxConnections設定 [条件付き]
                                       │      ├─ DoOnListen()
                                       │      └─ Application.Run()
                                       │
                                       └─ [FPC版]
                                              ├─ ModuleName := FModuleName
                                              ├─ HandlerName := FHandlerName
                                              ├─ SetModuleRecord(FDefaultModule^)
                                              ├─ AllowDefaultModule := True
                                              ├─ OnGetModule := DoGetModule
                                              ├─ LegacyRouting := True
                                              ├─ DoOnListen()
                                              └─ Initialize()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Apache                 ┌─────────────────────────┐
   │                   │   Apache プロバイダー   │
   │                   │   (モジュールインプロセス)
   ├─ リクエスト ─────▶│                         │
   │                   └───────────┬─────────────┘
   │                               │
   │                               ▼
   │                   ┌─────────────────────────┐
   │                   │   THorseWebModule       │───────▶ Apache
   │                   │ (リクエスト処理委譲)   │         (レスポンス)
   │                   └───────────┬─────────────┘
   │                               │
   │                               ▼
   │                   ┌─────────────────────────┐
   │                   │   THorseCore.Routes     │
   │                   │   (ルーティング実行)    │
   │                   └─────────────────────────┘
   │
   └─ Apache設定 ─────────────────────────────────────▶ HandlerName/ModuleName
       (httpd.conf)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、コンパイルディレクティブによるプロバイダー選択 |
| Horse.Provider.Apache.pas | `src/Horse.Provider.Apache.pas` | ソース | Apache プロバイダー実装（Delphi版） |
| Horse.Provider.FPC.Apache.pas | `src/Horse.Provider.FPC.Apache.pas` | ソース | Apache プロバイダー実装（FPC版） |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModuleクラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| Apache.dpr | `samples/delphi/apache/Apache.dpr` | プロジェクト | Apacheサンプルプロジェクト（Delphi） |
| Apache.pas | `samples/lazarus/apache/Apache.pas` | サンプル | Apacheサンプル（Lazarus） |
